unit uMessSender;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, uMessageCommons;

type
  TForm1 = class(TForm)
    imPicture: TImage;
    edInteger: TEdit;
    mmText: TMemo;
    btnSendImage: TButton;
    btnSendInteger: TButton;
    btnSendString: TButton;
    OpenDialog1: TOpenDialog;
    procedure btnSendIntegerClick(Sender: TObject);
    procedure imPictureClick(Sender: TObject);
    procedure btnSendStringClick(Sender: TObject);
    procedure btnSendImageClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FMapHandle: THandle;
    FMapPointer: pchar;
    FReadWriteLock: THandle;
    FDataReady: THandle; 
    procedure SendData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.imPictureClick(Sender: TObject);
begin
   if OpenDialog1.Execute then
      imPicture.Picture.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.SendData(aData: TMemoryStream);
   procedure _doSendData;
   var
      _sz: integer;
   begin
      try
         { check if there is unprocessed data }
         if FMapPointer[0] = #0 then
            begin
               { check data size }
               if (aData.Size > MEMORYMAPSIZE) then
                  raise Exception.Create('data too big!');
               { set it as unprocessed }
               FMapPointer[0]:= #1;
               _sz:= aData.size;
               move(_sz, FMapPointer[1], 4);
               { put the data in common memory }
               Move(aData.memory^, FMapPointer[5], aData.Size);
               { set the semaphore for data }
               if not ReleaseSemaphore(FDataReady, 1, nil) then
                  RaiseLastWin32Error;
            end
         else
            ShowMessage('there is unprocessed data');
      finally
         { finish the create lock }
         ReleaseMutex(FReadWriteLock);
      end;
   end;
begin
   { try to lock the memory }
   case WaitForSingleObject(FReadWriteLock, 100) of
      WAIT_TIMEOUT: ShowMessage('timed out waiting for lock');
      WAIT_OBJECT_0: _doSendData;
      WAIT_ABANDONED:
         begin
            ShowMessage('server gone while processing data');
            _doSendData;
         end;
      else
         RaiseLastWin32Error;
   end;
end;

procedure TForm1.btnSendIntegerClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtInteger);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _int:= StrToIntDef(edInteger.Text, 0);
      _msg.Write(_int, SizeOf(integer));
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendStringClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
   _ln: integer;
   _str: string;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtString);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _str:= mmText.Text;
      _ln:= length(_str);
      if (_ln > 0) then
         _msg.Write(_str[1], _ln);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendImageClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtImage);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      imPicture.Picture.Bitmap.SaveToStream(_msg);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   _s: string;
   _name: string;
begin
   _name:= 'testmap';
   { create the memory map }
   _s:= _name + '.File';
   FMapHandle := CreateFileMapping($FFFFFFFF, nil, PAGE_READWRITE, 0, MEMORYMAPSIZE + 5, PChar(_s));
   if (FMapHandle = 0) then
      RaiseLastWin32Error;
   { get the memory address }
   FMapPointer:= MapViewOfFile(FMapHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);
   { create the read write protection }
   _s:= _name + '.ReadWriteLock';
   FReadWriteLock:= CreateMutex(nil, false, pchar(_s));
   if (FReadWriteLock = 0) then
      RaiseLastWin32Error;
   { data available semaphore }
   _s:= _name + '.Data';
   FDataReady:= CreateSemaphore(nil, 0, MaxInt-1, pchar(_s));
   if (FDataReady = 0) then
      RaiseLastWin32Error;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   if (FReadWriteLock <> 0) then
      CloseHandle(FReadWriteLock);
   if (FDataReady <> 0) then
      CloseHandle(FDataReady);
   { free the map }
   if (FMapPointer <> nil) then
      UnmapViewOfFile(FMapPointer);
   if (FMapHandle <> 0) then
      CloseHandle(FMapHandle);
end;

end.
